#include "Mesquite_all_headers.hpp"
#include <iostream>
#include <sstream>
#include<algorithm>
#include<vector>
#include<map>
#include<cmath>
#include "CompositeOFExponent.hpp"
#include "CompositeOFNLog.hpp"
#include "MeshBoundaryDomain2D.cpp"


#include "jibum_untangle.cpp"

using std::cout;
using std::cerr;
using std::endl;
using std::ostream;
using std::ostringstream;

#include <memory>
using std::auto_ptr;

#include <ctype.h>
#include <time.h>

using namespace MESQUITE_NS;

struct timespec time1, time2;

double timediff(struct timespec * timeA_p, struct timespec * timeB_p)
{
  double t = ((timeA_p->tv_sec * 1000000000) + timeA_p->tv_nsec) -
           ((timeB_p->tv_sec * 1000000000) + timeB_p->tv_nsec);

  return t / 1000000000;
}


void deformBoundary( MeshImpl& deformedMesh, MeshImpl& origMesh, double a)
{
  MsqPrintError err(cerr);

  std::vector<Mesh::VertexHandle> vertices;
  origMesh.get_all_vertices(vertices, err);
  if (MSQ_CHKERR(err)) {std::cout << err << std::endl; exit(EXIT_FAILURE);}
  size_t num_vertices = vertices.size();
  
  cout<<"num vertices="<<num_vertices<<endl;
  // get vertex coordinates
  std::vector<MsqVertex> coordinates(num_vertices);
  origMesh.vertices_get_coordinates( arrptr(vertices), arrptr(coordinates), num_vertices, err);
  if (MSQ_CHKERR(err)) {std::cout << err << std::endl; exit(EXIT_FAILURE);}
  
  // get application fixed vertices
  std::vector<bool> app_fixed(num_vertices);
  origMesh.vertices_get_fixed_flag( arrptr(vertices), app_fixed, num_vertices, err );

  if (MSQ_CHKERR(err)) {std::cout << err << std::endl; exit(EXIT_FAILURE);}
  
  cout<<"num fixed vertices="<<app_fixed.size()<<endl;

 // double twopi=8.0*atan(1.0);

  for(size_t i=0;i<num_vertices; i++)
  {
    if( app_fixed[i] == true )
    {
      double x = coordinates[i].x();
    //  double y = 1.25*coordinates[i].y();
      double y = coordinates[i].y();
     // double z = coordinates[i].x()*coordinates[i].z();
 double z = coordinates[i].z();

   //   if( ( (1-(x*x/4.0 + y*y/16.0))<.00001 ) && (y>.01) )
   //   {
	//
	// set new boundary vertices for deformed mesh
	//
	Vector3D newPos(x,y,z);
	deformedMesh.vertex_set_coordinates(vertices[i], newPos, err);
	if (MSQ_CHKERR(err)) {std::cout << err << std::endl; exit(EXIT_FAILURE);}

     // }
    }
  }//end of loop over vertices

  deformedMesh.write_vtk("DeformedMesh.vtk", err);
  if (MSQ_CHKERR(err)) {std::cout << err << std::endl; exit(EXIT_FAILURE);}

  cout<<"Leaving deformBoundary."<<endl;
}//end of deformBoundary




int do_smoother( const char* input_file, const char* input_file_1, const char* output_file, int a)
{
  MsqPrintError err(cerr);
   
    bool mFixBndryInInterfaceSmooth = false; //this fixes exterior surface nodes
    bool project_gradient= false;
    double cos_crease_angle=0.2;
  //
  // Mesh we will be optimizing
  //
  MeshImpl mesh, deformedMesh;
  mesh.read_vtk( input_file, err );
  deformedMesh.read_vtk( input_file_1, err);

  mesh.write_vtk( "InitialMesh.vtk", err );
  deformedMesh.write_vtk( "DeformedMesh.vtk", err);


  // get all vertices
    std::vector<Mesquite::Mesh::VertexHandle> vertices;
    mesh.get_all_vertices(vertices, err);
    if (MSQ_CHKERR(err)) {std::cout << err << std::endl; exit(EXIT_FAILURE);}
    int num_vertices = vertices.size(); 
    cout << " number of vertices = "<< num_vertices<<endl;

 // get application fixed vertices
    std::vector<bool> app_fixed(num_vertices);

    mesh.vertices_get_fixed_flag(&(vertices[0]), app_fixed, num_vertices, err);

    // create planar domain for interior and assessor queues
    MESQUITE_NS::XYPlanarDomain geom;

    // create boundary domain and find mesh boundary
    Mesquite::MeshBoundaryDomain2D* mesh_domain = new Mesquite::MeshBoundaryDomain2D( MeshBoundaryDomain2D::XY, 0.0, project_gradient, 
                                                                                     Mesquite::MeshBoundaryDomain2D::QUADRATIC);
    mesh_domain->skin_area_mesh(&mesh,cos_crease_angle,"material");

    std::vector<MESQUITE_NS::Mesh::VertexHandle> theBoundaryVertices;
    mesh_domain->get_boundary_vertices( theBoundaryVertices );
    
    int num_boundary_vertices = theBoundaryVertices.size();

    std::vector<MESQUITE_NS::Mesh::VertexHandle> theBoundaryEdges;
    mesh_domain->get_boundary_edges( theBoundaryEdges );
    std::vector<bool> fixed_flags_boundary(num_boundary_vertices);

    // get application fixed boundary vertices
    std::vector<bool> app_fixed_boundary(num_boundary_vertices);
    mesh.vertices_get_fixed_flag(&(theBoundaryVertices[0]),app_fixed_boundary,num_boundary_vertices, err);

    // only fix  boundary vertices along corners
    int num_fixed_boundary_flags = 0;

    std::vector<MESQUITE_NS::Mesh::VertexHandle> theCornerVertices;
    mesh_domain->get_corner_vertices( theCornerVertices );

    // fix only vertices that are classified as corners
    for (int i = 0; i < num_boundary_vertices; i++)
    {
      //
      // if we allow boundary vertices to float, we do so here
      //
        if (!mFixBndryInInterfaceSmooth)
            fixed_flags_boundary[i] = false;
        else
            fixed_flags_boundary[i] = app_fixed_boundary[i];

        for (int j = 0; j < theCornerVertices.size(); j++)
        {
            if (theCornerVertices[j] == theBoundaryVertices[i])
            {
                fixed_flags_boundary[i] = true;
                num_fixed_boundary_flags++;
                break;
            }    
        }
    }
    printf("fixed %d of %d boundary vertices (those classified corner)\n", num_fixed_boundary_flags, num_boundary_vertices);




//  MeshImpl deformedMesh;
//  deformedMesh.read_vtk( input_file, err );

// deformBoundary(deformedMesh, mesh, 2);
  //
  // constrain it to be planar.
  //
//  if (MSQ_CHKERR(err)) return 2;
  //  XYPlanarDomain geom;
 // if (MSQ_CHKERR(err)) return 1;

//////////////////////////////////
//  TShapeSize2DNB1 target_metric;
 TShapeNB1 target_metric; 
//   TSizeNB1 target_metric_1;
//TShapeSize2DNB1 target_metric_1;
//   TUntangleBeta target_metric(0.1);
//////////////////////////////////


 // IdealShapeTarget W;

  ReferenceMesh refMesh( &mesh );
  RefMeshTargetCalculator W( &refMesh, false );

TQualityMetric mu( &W, &target_metric );
// TQualityMetric nu( &W, &target_metric_1 );
//  TQualityMetric nu(&W, &target_metric_1);
  //   TUntangleMu target_metric_2(&target_metric_1,0);

 // TQualityMetric lu(&W, &target_metric_2); 



 jibum_untangle nu(0.0001);

  //IdealWeightInverseMeanRatio inverse_mean_ratio(err);
//	jibum_size_metric int_si_qm;
//	jibum_int_si si_qm;
	//IdealWeightInverseMeanRatio inverse_mean_ratio(err);

//	// creat a template
//	PMeanPTemplate  objective_function( 2.0, &mu);
	PMeanPTemplate  obj_func1( 2.0, &mu);
        PMeanPTemplate  obj_func2( 2.0, &nu);
//	LPtoPTemplate  obj_func2(&nu, 2, err);
	double c = 1e+6;

CompositeOFAdd objective_function(&obj_func1, &obj_func2, 0);
  
   ConjugateGradient * boundary_alg = new Mesquite::SteepestDescent( objective_function);
    boundary_alg->use_element_on_vertex_patch();

    ConjugateGradient * interior_alg = new Mesquite::FeasibleNewton( objective_function );
    interior_alg->use_global_patch();

   // for boundary 
    int boundary_outer = 10;
    int boundary_inner = 1;

    Mesquite::TerminationCriterion* boundaryTermInner = new Mesquite::TerminationCriterion();
    Mesquite::TerminationCriterion* boundaryTermOuter = new Mesquite::TerminationCriterion();

    boundaryTermOuter->add_iteration_limit(boundary_outer);
    boundaryTermInner->add_iteration_limit(boundary_inner);

    // for interior
    Mesquite::TerminationCriterion* interiorTermInner = new Mesquite::TerminationCriterion();
    Mesquite::TerminationCriterion* interiorTermOuter = new Mesquite::TerminationCriterion();

    int interior_outer = 10;
    int interior_inner = 1;

    interiorTermInner->add_iteration_limit(interior_inner); // for global_patch mode
    interiorTermOuter->add_iteration_limit(interior_outer);

    boundary_queue.set_master_quality_improver(boundary_alg, err);
    interior_queue.set_master_quality_improver(interior_alg, err);

// we repeatedly change which flags are fixed in these iterations
    //
    std::vector<bool> fixed_flags(num_vertices);
   
    int mNumInterfaceSmoothIters(1);
    for (int j=0; j<mNumInterfaceSmoothIters; j++) {

	cout<<" Boundary + Interior smoothing pass "<< j<<"....."<<endl;
        
        // smooth boundary only
        for (int i = 0; i < num_vertices; i++) fixed_flags[i] = true;
        mesh.vertices_set_fixed_flag(&(vertices[0]),fixed_flags,num_vertices, err);
        if (MSQ_CHKERR(err)) {std::cout << err << std::endl; exit(EXIT_FAILURE);}

        mesh.vertices_set_fixed_flag(&(theBoundaryVertices[0]),fixed_flags_boundary,num_boundary_vertices, err);
        if (MSQ_CHKERR(err)) {std::cout << err << std::endl; exit(EXIT_FAILURE);}

        boundary_queue.run_instructions(&mesh, mesh_domain, err);
        if (MSQ_CHKERR(err)) {std::cout << err << std::endl; exit(EXIT_FAILURE);}
        cout<<" boundary smooth completed in "<<boundaryTermOuter->get_iteration_count()<<" outer and "<<boundaryTermInner->get_iteration_count()<<" inner iterations."<<endl;
        //
        // smooth interior only
	//
        if (!mFixBndryInInterfaceSmooth)
        {
            //
            // let all interior vertices float during the interior smooth.
            //
            for (int i = 0; i < num_vertices; i++) fixed_flags[i] = false;
            mesh.vertices_set_fixed_flag(&(vertices[0]),fixed_flags,num_vertices, err);
        }
        else
        {
            //
            // use the app_fixed settings for the fixed state of boundary vertices.
            //
            mesh.vertices_set_fixed_flag(&(vertices[0]),app_fixed,num_vertices, err);      
        }
        if (MSQ_CHKERR(err)) {std::cout << err << std::endl; exit(EXIT_FAILURE);}
        for (int i = 0; i < num_boundary_vertices; i++) fixed_flags[i] = true;

        mesh.vertices_set_fixed_flag(&(theBoundaryVertices[0]),fixed_flags,num_boundary_vertices, err);
        if (MSQ_CHKERR(err)) {std::cout << err << std::endl; exit(EXIT_FAILURE);}

        interior_queue.run_instructions(&mesh, &geom, err);
        if (MSQ_CHKERR(err)) {std::cout << err << std::endl; exit(EXIT_FAILURE);}
        cout<<" interior smooth completed in "<<interiorTermOuter->get_iteration_count()<<" outer and "<<interiorTermInner->get_iteration_count()<<" inner iterations."<<endl;

    }

 deformedMesh.write_vtk( output_file, err );



//  PMeanPTemplate objective_function( 2.0, &lu);
/*
	CompositeOFScalarMultiply obj_func11(1.0/c,&obj_func1,0);
	CompositeOFScalarMultiply obj_func21(1.0/c,&obj_func2,0);
	CompositeOFExponent obj_func12(&obj_func11,0);
	CompositeOFExponent obj_func22(&obj_func21,0);
	CompositeOFAdd obj_func3(&obj_func1, &obj_func2, 0);
	CompositeOFNLog obj_func31(&obj_func3, 0);
	CompositeOFScalarMultiply objective_function(c,&obj_func31,0);
*/

/*
  TerminationCriterion outer, inner;
  
//  FeasibleNewton solver( &objective_function );
   ConjugateGradient solver( &objective_function);

  if (MSQ_CHKERR(err)) return 1;

  solver.set_inner_termination_criterion( &inner );
  solver.set_outer_termination_criterion( &outer );
  
  bool isSolverGlobal = false;
 // bool isSolverGlobal = false;
  if( isSolverGlobal )
  {
    solver.use_global_patch();

    outer.add_iteration_limit( 1 );
    //       outer.add_relative_successive_improvement(1e-5);

    //       inner.add_absolute_vertex_movement(1e-5);
    inner.add_relative_successive_improvement(1e-7);
    // inner.write_mesh_steps("mesh_");
    //       inner.add_relative_element_overlap(0.5);

  }
  else  // local solver
  {
    solver.use_element_on_vertex_patch();

// outer.add_relative_quality_improvement(1e-4);
 
 outer.add_iteration_limit( a );
 inner.add_iteration_limit( 1 );
 //   outer.add_relative_successive_improvement(1e-9);
   //        outer.add_iteration_limit( 1 );
    // outer.write_mesh_steps("mesh_");

    //   inner.add_absolute_vertex_movement(1e-5);
   // inner.add_relative_successive_improvement(1e-5);
    // inner.add_iteration_limit( 2 );
  }
  
  
  jibum_untangle qm_metric;
  QualityAssessor assessor;
  assessor.add_quality_assessment( &mu, 10 );
  assessor.add_quality_assessment( &qm_metric );

  InstructionQueue q;
  q.add_quality_assessor( &assessor, err );
  q.set_master_quality_improver( &solver, err );
  q.add_quality_assessor( &assessor, err );

#if 0
  Settings theSettings;
  theSettings.set_slaved_ho_node_mode(Settings::SLAVE_NONE);
	
  q.run_common( &deformedMesh, NULL, &geom, &theSettings, err );
#else
  q.run_instructions( &deformedMesh, &geom, err);
#endif
  if (MSQ_CHKERR(err)) return 3;

 deformedMesh.write_vtk( output_file, err );
  if (MSQ_CHKERR(err)) return 2;
  cout << "Wrote: " << output_file << endl;
  cout<<" Convergence in "<<outer.get_iteration_count()<<" outer iterations."<<endl;
  cout<<" Convergence in "<<inner.get_iteration_count()<<" inner iterations."<<endl;

  cout<<"Leaving do_smoother."<<endl;


*/
  return 0;
}

int main( int argc, char* argv[] )
{

  timespec time1, time2; 
clock_gettime(CLOCK_MONOTONIC, &time1);
  MsqPrintError err(cout);
    
  ostringstream meshfile,meshfile_1, outfile;
 // double a=1.1;

 // if( argc > 1 )
 // {
 //   a = atof(argv[1]);
 // }
    
  int aaa = atof(argv[1]);
 // meshfile <<"/g/g92/kim74/mesquite-2.99/mesquite-debug/DeformingMeshes/hook.vtk";
 //  meshfile <<"/g/g92/kim74/mesquite-2.99/mesquite-debug/DeformingMeshes/foam5.vtk"; 

// meshfile <<"/g/g92/kim74/crown_initial.vtk"; 
// meshfile_1 << "/g/g92/kim74/crown_deformed.vtk";

// meshfile <<"/g/g92/kim74/airfoil_initial.vtk"; 
//  meshfile_1 << "/g/g92/kim74/airfoil_deformed_1.vtk";

 meshfile <<"./cylinder_initial_refined.vtk"; 
// meshfile_1 << "./cylinder_iso_inverted_two_dimension_101.vtk";
  meshfile_1 << "./test_boundary.vtk";

// meshfile <<"./annulus_tris.vtk"; 
// meshfile_1 << "./annulus_1_1_inverted_20_good.vtk";

  outfile<<"./SmoothedMesh.vtk";
 // int result = do_smoother( meshfile.str().c_str(), outfile.str().c_str(), a);
 int result = do_smoother( meshfile.str().c_str(), meshfile_1.str().c_str(), outfile.str().c_str(), aaa);
  cout<<" main finished."<<endl;
clock_gettime(CLOCK_MONOTONIC, &time2);
cout << "Setting up vector Time = " << timediff(&time2,&time1) <<  " sec" << endl;
  return result;
}

